// DEMODlg.cpp : implementation file
//

#include "stdafx.h"
#include "DEMO.h"
#include "DEMODlg.h"
#include "CtrlCard.h"
#include "BaseParaSet.h"
#include "IOTest.h"

#include "adt8940a1.h"

CCtrlCard	g_CtrlCard;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern int effectlogic_x;
extern int effectlogic_y;
extern int effectlogic_z;
extern int effectlogic_a;
extern int registermode;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDEMODlg dialog

CDEMODlg::CDEMODlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDEMODlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDEMODlg)
	m_nAddX = 0;
	m_nAddY = 0;
	m_nAddZ = 0;
	m_bX = FALSE;
	m_bY = FALSE;
	m_bZ = FALSE;
	m_nPulseX = 0;
	m_nPulseY = 0;
	m_nPulseZ = 0;
	m_nSpeedX = 0;
	m_nSpeedY = 0;
	m_nSpeedZ = 0;
	m_nStartvX = 0;
	m_nStartvY = 0;
	m_nStartvZ = 0;
	m_bDelayStatus = FALSE;
	m_nDelayTime = 0;
	m_nSpeedA = 0;
	m_nStartvA = 0;
	m_nPulseA = 0;
	m_bA = FALSE;
	m_nAddA = 0;
	m_dTaccX = 0.0;
	m_dTaccA = 0.0;
	m_dTaccY = 0.0;
	m_dTaccZ = 0.0;
	m_bManualContinue = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDEMODlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDEMODlg)
	DDX_Control(pDX, IDC_STATIC_TITLE, m_title);
	DDX_Text(pDX, IDC_ADD_X, m_nAddX);
	DDX_Text(pDX, IDC_ADD_Y, m_nAddY);
	DDX_Text(pDX, IDC_ADD_Z, m_nAddZ);
	DDX_Check(pDX, IDC_CHECK_X, m_bX);
	DDX_Check(pDX, IDC_CHECK_Y, m_bY);
	DDX_Check(pDX, IDC_CHECK_Z, m_bZ);
	DDX_Text(pDX, IDC_PULSE_X, m_nPulseX);
	DDX_Text(pDX, IDC_PULSE_Y, m_nPulseY);
	DDX_Text(pDX, IDC_PULSE_Z, m_nPulseZ);
	DDX_Text(pDX, IDC_SPEED_X, m_nSpeedX);
	DDX_Text(pDX, IDC_SPEED_Y, m_nSpeedY);
	DDX_Text(pDX, IDC_SPEED_Z, m_nSpeedZ);
	DDX_Text(pDX, IDC_STARTV_X, m_nStartvX);
	DDX_Text(pDX, IDC_STARTV_Y, m_nStartvY);
	DDX_Text(pDX, IDC_STARTV_Z, m_nStartvZ);
	DDX_Check(pDX, IDC_CHECK_DELAY, m_bDelayStatus);
	DDX_Text(pDX, IDC_EDIT_DELAYTIME, m_nDelayTime);
	DDX_Text(pDX, IDC_SPEED_A, m_nSpeedA);
	DDX_Text(pDX, IDC_STARTV_A, m_nStartvA);
	DDX_Text(pDX, IDC_PULSE_A, m_nPulseA);
	DDX_Check(pDX, IDC_CHECK_A, m_bA);
	DDX_Text(pDX, IDC_ADD_A, m_nAddA);
	DDX_Text(pDX, IDC_TACC_X, m_dTaccX);
	DDX_Text(pDX, IDC_TACC_A, m_dTaccA);
	DDX_Text(pDX, IDC_TACC_Y, m_dTaccY);
	DDX_Text(pDX, IDC_TACC_Z, m_dTaccZ);
	DDX_Check(pDX, IDC_CHECK_CONTINUE, m_bManualContinue);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDEMODlg, CDialog)
	//{{AFX_MSG_MAP(CDEMODlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_PMOVE, OnButtonPmove)
	ON_BN_CLICKED(IDC_BUTTON_INPMOVE, OnButtonInpmove)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	ON_BN_CLICKED(IDC_BUTTON_IOTEST, OnButtonIotest)
	ON_BN_CLICKED(IDC_BUTTON_BASEPARA, OnButtonBasepara)
	ON_BN_CLICKED(IDC_BUTTON_CLEARPOS, OnButtonClearpos)
	ON_BN_CLICKED(IDC_DELAY, OnDelay)
	ON_BN_CLICKED(IDC_COMP_MOVE, OnCompMove)
	ON_BN_CLICKED(IDC_LINEINP_MOVE, OnLineinpMove)
	ON_BN_CLICKED(IDC_CHECK_MANUAL, OnCheckManual)
	ON_BN_CLICKED(IDC_BUTTON_LOCKMODE, OnButtonLockmode)
	ON_BN_CLICKED(IDC_BUTTON_LOCKPOS, OnButtonLockpos)
	ON_BN_CLICKED(IDC_BUTTON_CLRLOCK, OnButtonClrlock)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDEMODlg message handlers

BOOL CDEMODlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
//*************set title**************	
	CWnd   *wnd;   	
	pFont.CreateFont(25,0,0,0,400,FALSE,FALSE,0,ANSI_CHARSET,OUT_STROKE_PRECIS, CLIP_STROKE_PRECIS,DEFAULT_QUALITY,VARIABLE_PITCH|FF_SWISS,_T(""));   
    wnd=(CWnd*)GetDlgItem(IDC_STATIC_TITLE);
	wnd->SetFont(&pFont); 

	int i;
	
	i=g_CtrlCard.Init_Board();
//*************initial 8940A1 motion-card**************
	if (i <= 0)
	{
        MessageBox( "Fail to initial motion-card!");
		
		if (i==0)
		{
			MessageBox( "NO installation of ADT8940A1!");
		}
		if(i==-1)
		{
			MessageBox( "no installation of service!");
		}
		if(i==-2)
		{
			MessageBox( "PCI bus failure!");
		}
	}                
    else
    
       MessageBox ("Succeed in initial motion-card!");
//****************************************

//*************Get Version**************
	float LibVer;         //Library Version
	float HardwareVer;    //Hardware Version
 
	g_CtrlCard.Get_Version(LibVer,HardwareVer);

	CStatic *lbl;

	CString str;

	lbl=(CStatic*)GetDlgItem(IDC_INFO_VER);

	str.Format("Library Ver:%1.1f\nHardware Ver: %1.1f",LibVer,HardwareVer);

	lbl->SetWindowText(str);
//****************************************

//******* set start-speed 1000	*********
	m_nStartvX = 1000;
	m_nStartvY = 1000;
	m_nStartvZ = 1000;
	m_nStartvA = 1000;
//*********set run-speed 2000********
	m_nSpeedX  = 2000; 
	m_nSpeedY  = 2000; 
	m_nSpeedZ  = 2000; 
	m_nSpeedA  = 2000; 
//*********set add 1500**********
	m_nAddX    = 1500;
	m_nAddY    = 1500;
	m_nAddZ    = 1500;
	m_nAddA    = 1500;
//********set pulse 100000******
	m_nPulseX  = 100000;
	m_nPulseY  = 100000;
	m_nPulseZ  = 100000;
	m_nPulseA  = 100000;

//***********set add time***************
	m_dTaccX = 0.1;
	m_dTaccY = 0.1;	
	m_dTaccZ = 0.1;
	m_dTaccA = 0.1;

//*********set delay time 0************
	m_nDelayTime = 0;

    UpdateData(FALSE);
//***********set time*************
	SetTimer(MAINTIMER,100,NULL);       

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDEMODlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDEMODlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDEMODlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


/*********************************
           axis move
*******************************/
void CDEMODlg::OnButtonPmove() 
{
	UpdateData(TRUE);

	long Startv[]={m_nStartvX,m_nStartvY,m_nStartvZ,m_nStartvA};  //start-speed

	long Speed[]={m_nSpeedX,m_nSpeedY,m_nSpeedZ,m_nSpeedA};       //run-speed

	long Add[]  ={m_nAddX,m_nAddY,m_nAddZ,m_nAddA};               //add

	if(m_bX) 
	{
        //*************set speed***************//
		g_CtrlCard.Setup_Speed(1, m_nStartvX, m_nSpeedX, m_nAddX);
	    //*************X axis move***************//		
		g_CtrlCard.Axis_Pmove(1, m_nPulseX);	
	}

	if(m_bY ) 
	{
        //*************set speed**************//
		g_CtrlCard.Setup_Speed(2, m_nStartvY, m_nSpeedY, m_nAddY);
	    //*************Y axis move****************//		
		g_CtrlCard.Axis_Pmove(2, m_nPulseY);	
	}
	if(m_bZ ) 
	{
        //************set speed**************//
	 	g_CtrlCard.Setup_Speed(3, m_nStartvZ, m_nSpeedZ, m_nAddZ);
	    //*************Z axis move**************//		
		g_CtrlCard.Axis_Pmove(3, m_nPulseZ);	
	}
	if(m_bA ) 
	{
         //*************set speed**************//
		g_CtrlCard.Setup_Speed(4, m_nStartvA, m_nSpeedA, m_nAddA);
	    //*************A axis move***************//		
		g_CtrlCard.Axis_Pmove(4, m_nPulseA);	
	}
}

/*********************************
           inp_move button
*********************************/
void CDEMODlg::OnButtonInpmove() 
{
	UpdateData();

	long Startv[]={m_nStartvX,m_nStartvY,m_nStartvZ,m_nStartvA};     //start-speed
	long Speed[]={m_nSpeedX,m_nSpeedY,m_nSpeedZ,m_nSpeedA};          //run-speed
	long Add[]  ={m_nAddX,m_nAddY,m_nAddZ,m_nAddA};                  //add
	long Pulse[]={m_nPulseX,m_nPulseY,m_nPulseZ,m_nPulseA};          //pulse
//	double Tacc[]={m_dTaccX,m_dTaccY,m_dTaccZ,m_dTaccA};			//add time

    //************interp-move with two axes***********//
	if(m_bX && m_bY && !m_bZ && !m_bA)                  //XY
	{
		g_CtrlCard.Setup_Speed(1, Startv[0], Speed[0], Add[0]);

		g_CtrlCard.Interp_Move2(1, 2, Pulse[0], Pulse[1]);
	}
	else if(m_bX && !m_bY && m_bZ && !m_bA)             //XZ
	{
		g_CtrlCard.Setup_Speed(1, Startv[0], Speed[0], Add[0]);

		g_CtrlCard.Interp_Move2(1, 3, Pulse[0], Pulse[2]);
	}
	else if(m_bX && !m_bY && !m_bZ && m_bA)             //XW
	{
		g_CtrlCard.Setup_Speed(1, Startv[0], Speed[0], Add[0]);

		g_CtrlCard.Interp_Move2(1, 4, Pulse[0], Pulse[3]);
	}
	else if(!m_bX && m_bY && m_bZ && !m_bA)            //YZ
	{
		g_CtrlCard.Setup_Speed(2, Startv[1], Speed[1], Add[1]);

		g_CtrlCard.Interp_Move2(2, 3, Pulse[1], Pulse[2]);
	}
	else if(!m_bX && m_bY && !m_bZ && m_bA)            //YW
	{
		g_CtrlCard.Setup_Speed(2, Startv[1], Speed[1], Add[1]);

		g_CtrlCard.Interp_Move2(2, 4, Pulse[1], Pulse[3]);
	}
	else if(!m_bX && !m_bY && m_bZ && m_bA)            //ZW
	{
		g_CtrlCard.Setup_Speed(3, Startv[2], Speed[2], Add[2]);

		g_CtrlCard.Interp_Move2(3, 4, Pulse[2], Pulse[3]);
	}

    //*************interp-move with 3-axis**************//
	else if(m_bX && m_bY && m_bZ && !m_bA) //XYZ
	{
		g_CtrlCard.Setup_Speed(1, Startv[0], Speed[0], Add[0]);

		g_CtrlCard.Interp_Move3(1, 2, 3, Pulse[0], Pulse[1], Pulse[2]);
	}
	else if(m_bX && m_bY && m_bZ && !m_bA) //XYZ
	{
		g_CtrlCard.Setup_Speed(1, Startv[0], Speed[0], Add[0]);

		g_CtrlCard.Interp_Move3(1, 2, 3, Pulse[0], Pulse[1], Pulse[2]);
	}
	else if(m_bX && m_bY && !m_bZ && m_bA) //XYW
	{
		g_CtrlCard.Setup_Speed(1, Startv[0], Speed[0], Add[0]);

		g_CtrlCard.Interp_Move3(1, 2, 4, Pulse[0], Pulse[1], Pulse[3]);
	}
	else if(m_bX && !m_bY && m_bZ && m_bA) //XZW
	{
		g_CtrlCard.Setup_Speed(1, Startv[0], Speed[0], Add[0]);

		g_CtrlCard.Interp_Move3(1, 3, 4, Pulse[0], Pulse[2], Pulse[3]);
	}
	else if(!m_bX && m_bY && m_bZ && m_bA) //YZW
	{
		g_CtrlCard.Setup_Speed(2, Startv[1], Speed[1], Add[1]);

		g_CtrlCard.Interp_Move3(2, 3, 4, Pulse[1], Pulse[2], Pulse[3]);
	}

    //************interp-move with 4-axis*************//
	else if(m_bX && m_bY && m_bZ && m_bA)            //XYZW
	{
		g_CtrlCard.Setup_Speed(1, Startv[0], Speed[0], Add[0]);

		g_CtrlCard.Interp_Move4(Pulse[0], Pulse[1], Pulse[2], Pulse[3]);
	}
	else
	{
		MessageBox("please choose the axis!");
	}

}
/******************************
        stop button
        sudden-stop all axis
*******************************/
void CDEMODlg::OnButtonStop() 
{

	for (int i = 1; i<=MAXAXIS; i++)
	{	
       g_CtrlCard.StopRun(i,0);   
    }
	
}
//********************Get Information*************************//
//     Get logic-pos,real-pos,run-speed,run-status        //
//     Read input signal of LMT+,LMT-,stop0 and stop1         //
//***********************************************************//
void CDEMODlg::OnTimer(UINT nIDEvent) 
{
	long log=0,act=0,spd=0;
	UINT nID1[]={IDC_POS_LOGX,IDC_POS_LOGY,IDC_POS_LOGZ,IDC_POS_LOGA};
	UINT nID2[]={IDC_POS_ACTX,IDC_POS_ACTY,IDC_POS_ACTZ,IDC_POS_ACTA};
	UINT nID3[]={IDC_RUNSPEED_X,IDC_RUNSPEED_Y,IDC_RUNSPEED_Z,IDC_RUNSPEED_A};
	CStatic *lbl;
	CString str;
	int status[4];
 	for (int i=1; i<MAXAXIS+1; i++)
	{
		g_CtrlCard.Get_CurrentInf(i,log,act,spd);    //Get logic-pos ,actual-pos and run-speed

		//********display logic-pos********//
		lbl=(CStatic*)GetDlgItem(nID1[i-1]);

		str.Format("%ld",log);

		lbl->SetWindowText(str);                      

		//********display actual-pos********//
		lbl=(CStatic*)GetDlgItem(nID2[i-1]);

		str.Format("%ld",act);

		lbl->SetWindowText(str);

		//********display run-speed********//
		lbl=(CStatic*)GetDlgItem(nID3[i-1]);

		str.Format("%ld",spd);		


		lbl->SetWindowText(str);

		//******Get status******//
		g_CtrlCard.Get_Status(i,status[i-1],0);

	}
    //******************Check signal*****************
    //     XLMT   0    XLMT+  1
    //     XSTOP0 2    XSTOP1 3
    //     YLMT   6    YLMT+  7
    //     YSTOP0 8    YSTOP1 9
    //     ZLMT   12   ZLMT+  13
    //     ZSTOP0 14   ZLMT+  15
    //     ALMT   18   ALMT+  19
    //     ASTOP0 20   ASTOP1 21
    //*******************************************
	UINT nIDIN[]={ IDC_LIMIT_X,IDC_LIMIT_X2,             //XLMT+/XLMT-
				   IDC_STOP0_X, IDC_STOP1_X ,            
		           IDC_LIMIT_Y, IDC_LIMIT_Y2,            //YLMT+/YLMT-
				   IDC_STOP0_Y,IDC_STOP1_X2, 
				   IDC_LIMIT_Z,IDC_LIMIT_Z2,             //ZLMT+/ZLMT-
				   IDC_STOP0_Z,IDC_STOP1_Z,
				   IDC_LIMIT_A,IDC_LIMIT_A2,             //ALMT+/ALMT-
				   IDC_STOP0_A,IDC_STOP1_A,             
				}; 

	int io[]={0,1,2,3,6,7,8,9,12,13,14,15,18,19,20,21};

	CButton *btn;
	int value;

	for (i=0; i<16; i++)
	{
		value=g_CtrlCard.Read_Input(io[i]);                   //read input signal

		btn=(CButton*)GetDlgItem(nIDIN[i]);

		btn->SetCheck(value==0?1:0);

	}


    //**************************contorl button****************************
	if(status[0]==0 && status[1]==0 && status[2]==0 && status[3]==0)
	{
	    //****************finished****************
		btn=(CButton*)GetDlgItem(IDC_BUTTON_PMOVE);

		btn->EnableWindow(TRUE);

		btn=(CButton*)GetDlgItem(IDC_BUTTON_INPMOVE);

		btn->EnableWindow(TRUE);

		btn=(CButton*)GetDlgItem(IDC_BUTTON_CLEARPOS);

		btn->EnableWindow(TRUE);

		btn=(CButton*)GetDlgItem(IDC_BUTTON_BASEPARA);

		btn->EnableWindow(TRUE);

		btn=(CButton*)GetDlgItem(IDC_BUTTON_IOTEST);
		
		btn->EnableWindow(TRUE);

		btn=(CButton*)GetDlgItem(IDC_LINEINP_MOVE);
		
		btn->EnableWindow(TRUE);

		btn=(CButton*)GetDlgItem(IDC_COMP_MOVE);
		
		btn->EnableWindow(TRUE);
	}
	else
	{
	    //**********running**********
		btn=(CButton*)GetDlgItem(IDC_BUTTON_PMOVE);

		btn->EnableWindow(FALSE);

		btn=(CButton*)GetDlgItem(IDC_BUTTON_INPMOVE);

		btn->EnableWindow(FALSE);

		btn=(CButton*)GetDlgItem(IDC_BUTTON_CLEARPOS);

		btn->EnableWindow(FALSE);

		btn=(CButton*)GetDlgItem(IDC_BUTTON_BASEPARA);

		btn->EnableWindow(FALSE);

		btn=(CButton*)GetDlgItem(IDC_BUTTON_IOTEST);
		
		btn->EnableWindow(FALSE);

		btn=(CButton*)GetDlgItem(IDC_LINEINP_MOVE);
		
		btn->EnableWindow(FALSE);

		btn=(CButton*)GetDlgItem(IDC_COMP_MOVE);
		
		btn->EnableWindow(FALSE);
	}

	
	CDialog::OnTimer(nIDEvent);
}

void CDEMODlg::OnButtonIotest() 
{
	CIOTest dlg;

	dlg.DoModal();	
}

void CDEMODlg::OnButtonBasepara() 
{
	CBaseParaSet dlg;

	dlg.DoModal();	
}

void CDEMODlg::OnButtonClearpos() 
{
	for(int i=1; i<MAXAXIS+1; i++)
	{
		g_CtrlCard.Setup_Pos(i, 0, 0);    //set logical-pos 0

		g_CtrlCard.Setup_Pos(i, 0, 1);    //set actual-pos  0
	}
	
}

void CDEMODlg::OnDelay() 
{
	UpdateData();	

	g_CtrlCard.Setup_Delay(m_nDelayTime);

	while(true)
	{
		DoEvent();
		m_bDelayStatus = g_CtrlCard.Get_DelayStatus();
		UpdateData(FALSE);
		if(m_bDelayStatus == false)
		    break;		
	}
	
}


//relative/absolute motion
void CDEMODlg::OnCompMove() 
{
	UpdateData(TRUE);	
	
	//ifRel=!ifRel;
	CButton *btn=(CButton*)GetDlgItem(IDC_COMP_MOVE);	
	if(btn->GetCheck())//Single axis symmetric absolute moving
	{
		btn->SetWindowText("abso-single-move");	
		
		if(m_bX  )
		{			
			g_CtrlCard.Sym_AbsoluteMove(1,  m_nPulseX,  m_nStartvX , m_nSpeedX,  m_dTaccX);
		}
		if(m_bY )
		{	
			g_CtrlCard.Sym_AbsoluteMove(2,  m_nPulseY,  m_nStartvY , m_nSpeedY,  m_dTaccY);
		}
		if(m_bZ )
		{				
			g_CtrlCard.Sym_AbsoluteMove(3,  m_nPulseZ,  m_nStartvZ , m_nSpeedZ,  m_dTaccZ);
		}
		if(m_bA )
		{
			g_CtrlCard.Sym_AbsoluteMove(4,  m_nPulseA,  m_nStartvA , m_nSpeedA,  m_dTaccA);
		}			
		else if (!m_bX && !m_bY && !m_bZ && !m_bA)
		{
			MessageBox("have't choose the axis!");
		}			
	}		
	else//Single axis symmetric relative moving
	{
		btn->SetWindowText("comp-single-move");	
		
		if(m_bX )
		{				
			g_CtrlCard.Sym_RelativeMove( 1,  m_nPulseX,  m_nStartvX , m_nSpeedX,  m_dTaccX);
		}
		if(m_bY )
		{				
			g_CtrlCard.Sym_RelativeMove( 2,  m_nPulseY,  m_nStartvY , m_nSpeedY,  m_dTaccY);
		}
		if(m_bZ )
		{
			
			g_CtrlCard.Sym_RelativeMove( 3,  m_nPulseZ,  m_nStartvZ , m_nSpeedZ,  m_dTaccZ);
		}
		if(m_bA )
		{
			
			g_CtrlCard.Sym_RelativeMove( 4,  m_nPulseA,  m_nStartvA , m_nSpeedA,  m_dTaccA);
		}	
		else if(!m_bX && !m_bY && !m_bZ && !m_bA)
		{
			MessageBox("have't choose the axis!");
		}			
	}
	
}

//linear interpolation absolute moving/relative moving
void CDEMODlg::OnLineinpMove() 
{
	UpdateData(TRUE);
	
	CButton *btn;
	
	btn=(CButton*)GetDlgItem(IDC_LINEINP_MOVE);
	if(btn->GetCheck())
	{
		btn->SetWindowText("abso-lineinp-move");	
		
		if(m_bX && m_bY && !m_bZ && !m_bA)//Two axes symmetric linear interpolation absolute moving
		{			
			g_CtrlCard.Sym_AbsoluteLine2(1, 2, m_nPulseX,m_nPulseY,  m_nStartvX , m_nSpeedX,  m_dTaccX);
		}
		else if(m_bX && !m_bY && m_bZ && !m_bA )
		{	
			g_CtrlCard.Sym_AbsoluteLine2(1, 3, m_nPulseX,m_nPulseZ, m_nStartvX , m_nSpeedX,  m_dTaccX);
		}
		else  if(m_bX && !m_bY && !m_bZ && m_bA  )
		{				
			g_CtrlCard.Sym_AbsoluteLine2(1, 4,  m_nPulseX,m_nPulseA,  m_nStartvX , m_nSpeedX,  m_dTaccX);
		}
		else if(!m_bX && m_bY && m_bZ && !m_bA)
		{
			g_CtrlCard.Sym_AbsoluteLine2(2, 3,  m_nPulseY,m_nPulseZ,  m_nStartvY , m_nSpeedY,  m_dTaccY);
		}			
		else if(!m_bX && m_bY && !m_bZ && m_bA )
		{
			g_CtrlCard.Sym_AbsoluteLine2(2, 4, m_nPulseY,m_nPulseA,m_nStartvY , m_nSpeedY,  m_dTaccY);
		}
		else if(!m_bX && !m_bY && m_bZ && m_bA )
		{
			g_CtrlCard.Sym_AbsoluteLine2(3, 4, m_nPulseZ,m_nPulseA,m_nStartvZ , m_nSpeedZ,  m_dTaccZ);
		}
		else if(m_bX && m_bY && m_bZ && !m_bA )// Three axes symmetric linear interpolation absolute moving
		{
			g_CtrlCard.Sym_AbsoluteLine3(1, 2, 3, m_nPulseX,m_nPulseY, m_nPulseZ, m_nStartvX , m_nSpeedX,  m_dTaccX);
		}
		else if(m_bX && m_bY && !m_bZ && m_bA )
		{
			g_CtrlCard.Sym_AbsoluteLine3(1, 2, 4, m_nPulseX,m_nPulseY, m_nPulseA, m_nStartvX , m_nSpeedX,  m_dTaccX);
		}
		
		else if(m_bX && !m_bY && m_bZ && m_bA )
		{
			g_CtrlCard.Sym_AbsoluteLine3(1, 3, 4, m_nPulseX,m_nPulseZ, m_nPulseA, m_nStartvX , m_nSpeedX,  m_dTaccX);
		}
		else if(!m_bX && m_bY && m_bZ && m_bA )
		{
			g_CtrlCard.Sym_AbsoluteLine3(2, 3, 4, m_nPulseY,m_nPulseZ, m_nPulseA, m_nStartvY , m_nSpeedY,  m_dTaccY);
		}
		else if(m_bX && m_bY && m_bZ && m_bA )//Four axes symmetric linear interpolation absolute moving
		{
			g_CtrlCard.Sym_AbsoluteLine4(m_nPulseX,m_nPulseY,m_nPulseZ, m_nPulseA, m_nStartvX , m_nSpeedX,  m_dTaccX);
		}

		else if(!m_bX && !m_bY && !m_bZ && !m_bA)
		{
			MessageBox("Please choose the axis for inp-move!");
		}			
	}		
	else	//Two axes asymmetric linear interpolation relative moving
	{
		btn->SetWindowText("comp-lineinp-move");	
		
		if(m_bX && m_bY && !m_bZ && !m_bA)
		{			
			g_CtrlCard.Sym_RelativeLine2(1, 2, m_nPulseX,m_nPulseY,  m_nStartvX , m_nSpeedX,  m_dTaccX);
		}
		else if(m_bX && !m_bY && m_bZ && !m_bA )
		{	
			g_CtrlCard.Sym_RelativeLine2(1, 3, m_nPulseX,m_nPulseZ, m_nStartvX , m_nSpeedX,  m_dTaccX);
		}
		else if(m_bX && !m_bY && !m_bZ && m_bA  )
		{				
			g_CtrlCard.Sym_RelativeLine2(1, 4,  m_nPulseX,m_nPulseA,  m_nStartvX , m_nSpeedX,  m_dTaccX);
		}
		else if(!m_bX && m_bY && m_bZ && !m_bA)
		{
			g_CtrlCard.Sym_RelativeLine2( 2, 3,  m_nPulseY,m_nPulseZ,  m_nStartvY , m_nSpeedY,  m_dTaccY);
		}			
		else if(!m_bX && m_bY && !m_bZ && m_bA )
		{
			g_CtrlCard.Sym_RelativeLine2(2, 4, m_nPulseY,m_nPulseA,m_nStartvY , m_nSpeedY,  m_dTaccY);
		}
		else if(!m_bX && !m_bY && m_bZ && m_bA )
		{
			g_CtrlCard.Sym_RelativeLine2(3, 4, m_nPulseZ,m_nPulseA,m_nStartvZ , m_nSpeedZ,  m_dTaccZ);
		}
		
		if(m_bX && m_bY && m_bZ && !m_bA )// Three axes asymmetric linear interpolation relative moving
		{
			g_CtrlCard.Sym_RelativeLine3(1, 2, 3, m_nPulseX,m_nPulseY, m_nPulseZ, m_nStartvX , m_nSpeedX,  m_dTaccX);
		}
		else if(m_bX && m_bY && !m_bZ  && m_bA )
		{
			g_CtrlCard.Sym_RelativeLine3(1, 2, 4, m_nPulseX,m_nPulseY, m_nPulseA, m_nStartvX , m_nSpeedX,  m_dTaccX);
		}
		else if(m_bX && !m_bY && m_bZ && m_bA )
		{
			g_CtrlCard.Sym_RelativeLine3(1, 3, 4, m_nPulseX,m_nPulseZ, m_nPulseA, m_nStartvX , m_nSpeedX,  m_dTaccX);
		}
		else if(!m_bX && m_bY && m_bZ && m_bA )
		{
			g_CtrlCard.Sym_RelativeLine3(2, 3, 4, m_nPulseY,m_nPulseZ, m_nPulseA, m_nStartvY , m_nSpeedY,  m_dTaccY);
		}
		else if(m_bX && m_bY && m_bZ && m_bA )//Four axes asymmetric linear interpolation relative moving
		{
			g_CtrlCard.Sym_RelativeLine4( m_nPulseX,m_nPulseY,m_nPulseZ, m_nPulseA, m_nStartvX , m_nSpeedX,  m_dTaccX);
		}

		else  if(!m_bX && !m_bY && !m_bZ && !m_bA)
		{
			MessageBox("Please choose the axis for inp-move!");
		}			
	}
	
}



//Set Manual
void CDEMODlg::OnCheckManual() 
{
    static bool manual=false;
	int i;

	UpdateData(TRUE);

    if(!m_bX && !m_bY && !m_bZ && !m_bA)
	{
		MessageBox("Please choose axis!");
		return ;
	}

	UpdateData(TRUE);
	
	long Startv[]={m_nStartvX,m_nStartvY,m_nStartvZ,m_nStartvA};  //start-speed
	
	long Speed[]={m_nSpeedX,m_nSpeedY,m_nSpeedZ,m_nSpeedA};       //run-speed
	
	long Add[]  ={m_nAddX,m_nAddY,m_nAddZ,m_nAddA};             //add	
		
	long Pulse[] ={m_nPulseX,m_nPulseY,m_nPulseZ,m_nPulseA};   //pluse
		
	manual=!manual;

	GetDlgItem(IDC_CHECK_MANUAL)->SetWindowText(manual?"manual enable":"manual disable");
	if (manual)
	{
		if (!m_bManualContinue)
		{
			if(m_bX)  
			{
				g_CtrlCard.Setup_Speed(1, Startv[0], Speed[0], Add[0]);
				g_CtrlCard.Manu_Pmove(1,Pulse[0]);    //X ration manual driving
			}
			if(m_bY)  
			{
				g_CtrlCard.Setup_Speed(2, Startv[1], Speed[1], Add[1]);
				g_CtrlCard.Manu_Pmove(2,Pulse[1]);    //Y ration manual driving
			}
			if(m_bZ)  
			{
				g_CtrlCard.Setup_Speed(3, Startv[2], Speed[2], Add[2]);
				g_CtrlCard.Manu_Pmove(3,Pulse[2]);    //Z ration manual driving
			}
			if(m_bA)  
			{
				g_CtrlCard.Setup_Speed(4, Startv[3], Speed[3], Add[3]);
				g_CtrlCard.Manu_Pmove(4,Pulse[3]);    //A ration manual driving
			}
		}
		else
		{
			if(m_bX)  
			{
				g_CtrlCard.Setup_Speed(1, Startv[0], Speed[0], Add[0]);
				g_CtrlCard.Manu_Continue(1);     //X manual continuous driving
			}
			if(m_bY)  
			{
				g_CtrlCard.Setup_Speed(2, Startv[1], Speed[1], Add[1]);
				g_CtrlCard.Manu_Continue(2);     //Y manual continuous driving
			}
			if(m_bZ)  
			{
				g_CtrlCard.Setup_Speed(3, Startv[2], Speed[2], Add[2]);
				g_CtrlCard.Manu_Continue(3);     //Z manual continuous driving
			}
			if(m_bA)  
			{
				g_CtrlCard.Setup_Speed(4, Startv[3], Speed[3], Add[3]);
				g_CtrlCard.Manu_Continue(4);     //A manual continuous driving
			}
		}
		
	}
	else
	{
		for (i=1; i<5; i++)
		{			
			g_CtrlCard.Manu_Disable(i);
		}
	}	
}

//set lockmode
void CDEMODlg::OnButtonLockmode() 
{
	UpdateData(TRUE);

	if(m_bX)
	{
		g_CtrlCard.Setup_LockPosition(1,1,registermode,effectlogic_x);
	}
	if(m_bY)
	{
		g_CtrlCard.Setup_LockPosition(2,1,registermode,effectlogic_y);
	}
	if(m_bZ)
	{
		g_CtrlCard.Setup_LockPosition(3,1,registermode,effectlogic_z);
	}
	if(m_bA)
	{
		g_CtrlCard.Setup_LockPosition(4,1,registermode,effectlogic_a);
	}
	else if(!m_bX && !m_bY && !m_bZ && !m_bA)
	{
		MessageBox("Please choose axis!");
	}	
}

//set lockmode
void CDEMODlg::OnButtonLockpos() 
{
int status=0;
	
	long posx,posy,posz,posw;
	
	CString str;
	
	UpdateData(TRUE);
	
    if(m_bX && !m_bY && !m_bZ && !m_bA)
	{
		g_CtrlCard.Get_LockStatus(1,status);
	}
	if(m_bY && !m_bX && !m_bZ && !m_bA)
	{
		g_CtrlCard.Get_LockStatus(2,status);
	}
	if(m_bZ && !m_bY && !m_bX && !m_bA)
	{
		g_CtrlCard.Get_LockStatus(3,status);
	}
	if(m_bA && !m_bY && !m_bZ && !m_bX)
	{
		g_CtrlCard.Get_LockStatus(4,status);
	}
	if (status)
	{
		g_CtrlCard.Get_LockPosition(1,posx);
		g_CtrlCard.Get_LockPosition(2,posy);
		g_CtrlCard.Get_LockPosition(3,posz);
		g_CtrlCard.Get_LockPosition(4,posw);
		
		str.Format("x:%ld,y:%ld,z:%ld,w:%ld",posx,posy,posz,posw);
		
		MessageBox(str,"the lockpos");
	}
	else if(!m_bA && !m_bY && !m_bZ && !m_bX)
	{
		MessageBox("Please choose the lock-pos-axis!");
	}	
}

//Clear pos
void CDEMODlg::OnButtonClrlock() 
{
	for(int i=1; i<MAXAXIS+1; i++)
	{
	    g_CtrlCard.Clr_LockPosition(i);
	}		
}
